var User = new Class({  
  owner: null,
	el: null,
  id: null,
  info: null,
	contacts: new Hash(),
	conversations: new Hash(),
	profiles: new Hash(),
	histories: new Hash(),
	refresh_timer: null,
	refresh_interval: 5000,
	refresh_server: null,
	
  initialize: function(o, info){
		this.owner = o;
		if($defined(info)) this.loadInfo(info);
		
    this.owner.loadCSS('user');
		var tpl = new Template("user");
    this.el = new Element('div').adopt(tpl.xml).getFirst();
				
		var t = this;
		
		this.refresh_server = new Server({silent: true});
		var refresh = function(){this.refreshInformation();}
		this.refresh_timer = refresh.periodical(this.refresh_interval, this);
		
		this.el.getElement('a.cprofile').addEvent('click', function(){
			if (t.info.anonymous) {
				alert('Neregistrovaní používatelia nemôžu upravovať svoj profil');
				return;
	  	}
			t.showProfile();
		});		
		
		this.owner.addEvent('closing', function(){
			t.conversations.each(function(item){
				item.close();
			});
			t.profiles.each(function(item){
				item.close();
			});
			t.histories.each(function(item){
				item.close();
			});
		});
  },
	
	getEl: function(){
		this.el.getElement('.nick').set('html', this.info.nick);
		return this.el;
	},
	
  logout: function(){
		// stop periodical getting of new messages
		this.refresh_timer = $clear(this.refresh_timer);
		
    // try to make logout request
    this.owner.server.request({'action': 'logout', 'args': {}});
		
		this.fireEvent('logout');
		
		// remove stored login information
    air.EncryptedLocalStore.reset();
  },
  
	// set user information
	loadInfo: function(info){
		this.id = info['id'];
    this.info = info;
		this.info.anonymous = this.info.anonymous == "1";
    this.fireEvent('InfoUpdate');
	},
	
	// set contacts to contact list
	loadContacts: function(list){
    this.contacts.empty();
		var t = this;
		$each(list, function(item){
	    t.contacts.set(item.id, item);
		});
    this.fireEvent('ContactListUpdate');
	},
	
	removeContact: function(id_user){
    var t = this;
    this.owner.server.request({'action': 'remove_contact', 'args': {'id_contact': id_user}}, function(response){
      if(!$defined(response) || !$defined(response.contacts)){
        alert('Chyba: nepodarilo sa odstrániť kontakt.');
      
      } else {
				t.loadContacts(response.contacts);
        t.fireEvent('ContactListUpdate');
      }
    });
	},
  
  addContact: function(id_user, onComplete){
    var t = this;
    this.owner.server.request({'action': 'add_contact', 'args': {'id_contact': id_user}}, function(response){
      if(!$defined(response) || !$defined(response.contacts)){
        alert('Chyba: nepodarilo sa pridať kontakt.');
        if($defined(onComplete)) onComplete(false);
				
      } else {
        t.loadContacts(response.contacts);
        t.fireEvent('ContactListUpdate');
				if($defined(onComplete)) onComplete(true);
      }
    });
  },
	
	startConversation: function(id_user){
		if(!this.conversations.has(id_user)){
			this.conversations.set(id_user, new Conversation(this.owner, id_user));			
		}
		this.conversations.get(id_user).open();
	},
	
	endConversation: function(id_user){
		if(this.conversations.has(id_user)) this.conversations.erase(id_user);
	},
	
	showContactProfile: function(id_user){
		if(!this.profiles.has(id_user)){
			this.profiles.set(id_user, new Profile(this.owner, {editable: this.info.anonymous ? [] : ['nick']}, this.contacts.get(id_user)));			
		}
		this.profiles.get(id_user).open();		
	},
	
	showContactHistory: function(id_user){
		if(!this.histories.has(id_user)){
			this.histories.set(id_user, new History(this.owner, {}, this.contacts.get(id_user)));			
		}
		this.histories.get(id_user).open();		
	},
	
	closeContactHistory: function(id_user){
		if(this.histories.has(id_user)) this.histories.erase(id_user);		
	},
	
	showProfile: function(){
		if(!this.profiles.has(this.id)){
			var info = new Hash(this.info);
			this.profiles.set(this.id, new Profile(this.owner, {editable: info.getKeys()}, this.info));			
		}
		this.profiles.get(this.id).open();		
	},
	
	closeProfile: function(id_user){
		if(this.profiles.has(id_user)) this.profiles.erase(id_user);		
	},
	
	// obnovi konverzacie - nacita do nich nove spravy pripadne zacne nove konverzacie
	// nastavi nove stavy na kontaktoch
	refreshInformation: function(){
		var t = this;
    this.refresh_server.request({'action': 'get_information', 'args': {'get_contacts': {}, 'get_messages': {}, 'get_user_info': {}}}, function(response){
			
      if($defined(response)){
				if ($defined(response.contacts)) {
					t.loadContacts(response.contacts);
					t.fireEvent('ContactListUpdate');
				}
				
				if ($defined(response.messages)){
					$each(response.messages, function(msg){
						// vytvorime novu (resp. obnovime staru) konverzaciu
						t.startConversation(msg.id_user_contact);
						
						// vlozime spravu do konverzacie
						t.conversations.get(msg.id_user_contact).messages.push({'type': 'recieved', 'id_user': msg.id_user_contact, 'text': msg.text, 'time': msg.sent_time});
						
						// nechame obnovit panel sprav - nech sa vykreslia nove spravy
						t.conversations.get(msg.id_user_contact).reload();
					});
				}
				
				if ($defined(response.user)){
					t.loadInfo(response.user);
					t.getEl();
				}
      }
    });
	}
});

User.implement(new Events);